//
//  WSUpdateReserve.h
//  WSUpdateReserve
//  升级保留链接处理模块
//  Created by SZ11041142c02 on 11-4-12.
//  Copyright 2011 Wondershare. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface WSUpdateReserve : NSObject {
	
}

+ (id)share;

//按名称查询配置信息，用于升级保留链接查询
- (NSString *)searchURLByKey:(NSString *)keyName;

//根据键名称和语言名称查询
//语言名可以是全称也可以是全写，如 "English","en"
- (NSString *)searchURLByKey:(NSString *)keyName andLanName:(NSString *)languageName;

//返回当前所用语言所有的URL链接
- (NSDictionary *)defaultLanURLs;

//根据语言名称获取所有URL链接  
- (NSDictionary *)allURLsByLanguageName:(NSString *)languageName;

//自动保存所有数据
//升级之前和升级之后都需要调用此方法（升级之前调用此方法是为了确保备份Resources目录下的Customization.xml）
//升级之后，它会自动替换那些升级保留的链接到语言包
- (BOOL)autoSaveUpdateReserve;
@end
